/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWException;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWStepProcessorObject;
import filenet.vw.api.VWXMLConfiguration;
import filenet.vw.api.VWXMLHandler;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public final class VWStepProcessorInfoDefinition
extends VWStepProcessorObject
implements Cloneable,
IVWtoXML,
Serializable {
    private static final long serialVersionUID = 7465L;
    public static final int PROCESSOR_LAUNCH = 4;
    public static final int PROCESSOR_STEP = 8;
    public static final int PROCESSOR_LAUNCH_DEFAULT = 1;
    public static final int PROCESSOR_STEP_DEFAULT = 2;
    public static final int PROCESSOR_DEFAULT = 3;
    public static final int APP_TYPE_URL = 32;
    public static final int APP_TYPE_JAVA = 64;
    private boolean alreadyTransferred = false;
    protected boolean isSelectedForExport = false;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-08 22:19:29 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/5 $";
    }

    public VWStepProcessorInfoDefinition() {
    }

    public VWStepProcessorInfoDefinition(int theId, int theProcessorType, String theName, int theAppType, String theLocation, int theWidth, int theHeight, String theApp) throws VWException {
        if ((theProcessorType & 1) != 1 && (theProcessorType & 2) != 2 && (theProcessorType & 4) != 4 && (theProcessorType & 8) != 8) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadType", "Illegal step processor info type.");
        }
        if (theAppType != 32 && theAppType != 64) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadAppType", "Illegal step processor info application type.");
        }
        this.m_processorType = theProcessorType | theAppType;
        this.m_name = theName;
        this.m_width = theWidth;
        this.m_height = theHeight;
        this.m_application = theApp;
        this.m_id = theId;
        if (theLocation == null) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadLocation", "Step processor info location cannot be null.");
        }
        if (this.m_locations == null) {
            this.m_locations = new Hashtable(1);
        }
        this.m_locations.put(new Integer(this.m_defaultWebAppId), theLocation);
    }

    public VWStepProcessorInfoDefinition(int theId, int theProcessorType, String theName, int theAppType, Hashtable theLocations, int theWidth, int theHeight, String theApp) throws VWException {
        if ((theProcessorType & 1) != 1 && (theProcessorType & 2) != 2 && (theProcessorType & 4) != 4 && (theProcessorType & 8) != 8) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadType", "Illegal step processor info type.");
        }
        if (theAppType != 32 && theAppType != 64) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadAppType", "Illegal step processor info application type.");
        }
        this.m_processorType = theProcessorType | theAppType;
        this.m_name = theName;
        this.m_locations = theLocations;
        this.m_width = theWidth;
        this.m_height = theHeight;
        this.m_application = theApp;
        this.m_id = theId;
    }

    public VWStepProcessorInfoDefinition(VWStepProcessorInfo stepProcessorInfo) throws VWException {
        if (stepProcessorInfo == null) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionNullStepProcessorInfo", "The step proceessor info object cannot be null.");
        }
        int nProcessorType = stepProcessorInfo.getProcessorType();
        if ((nProcessorType & 1) != 1 && (nProcessorType & 2) != 2 && (nProcessorType & 4) != 4 && (nProcessorType & 8) != 8) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadType", "Illegal step processor info type.");
        }
        int nAppType = stepProcessorInfo.getAppType();
        if (nAppType != 32 && nAppType != 64) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadAppType", "Illegal step processor info application type.");
        }
        this.m_name = stepProcessorInfo.m_name;
        this.m_locations = stepProcessorInfo.m_locations;
        this.m_id = stepProcessorInfo.m_id;
        this.m_processorType = nProcessorType | nAppType;
        this.m_height = stepProcessorInfo.m_height;
        this.m_width = stepProcessorInfo.m_width;
        this.m_application = stepProcessorInfo.m_application;
    }

    public void getCopy(VWStepProcessorInfoDefinition aSPID) {
        this.m_name = aSPID.m_name;
        this.m_locations = aSPID.m_locations;
        this.m_id = aSPID.m_id;
        this.m_processorType = aSPID.m_processorType;
        this.m_height = aSPID.m_height;
        this.m_width = aSPID.m_width;
        this.m_application = aSPID.m_application;
        this.m_bHasChanged = aSPID.m_bHasChanged;
        this.alreadyTransferred = aSPID.alreadyTransferred;
    }

    protected VWStepProcessorInfoDefinition(String theValue) throws VWException {
        super.setValue(theValue);
    }

    public int getId() {
        return super.getId();
    }

    public String getName() {
        return super.getName();
    }

    public String getLocation() {
        return super.getLocation();
    }

    public String getLocation(int nWebApp) {
        return (String)this.m_locations.get(new Integer(nWebApp));
    }

    public Hashtable getLocations() {
        return super.getLocations();
    }

    public int getProcessorType() {
        return super.getProcessorType();
    }

    public int getAppType() {
        return super.getAppType();
    }

    public boolean isDefaultType() {
        return super.isDefaultType();
    }

    public int getHeight() {
        return super.getHeight();
    }

    public int getWidth() {
        return super.getWidth();
    }

    public String getApplicationName() {
        return super.getApplicationName();
    }

    protected void setValue(String theNewValue) throws VWException {
        super.setValue(theNewValue);
    }

    protected void setAlreadyTransferred() {
        this.alreadyTransferred = true;
    }

    public void setName(String theName) throws VWException {
        if (this.alreadyTransferred) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionCantChangeTransferredName", "Cannot change the name of the step processor because it has already been committed (transferred to the server).");
        }
        if (theName == null) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadName", "Step processor info name cannot be null.");
        }
        this.m_name = theName;
        this.m_bHasChanged = true;
    }

    public void setLocation(String theLocation) throws VWException {
        if (theLocation == null) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadLocation", "Step processor info location cannot be null.");
        }
        if (this.m_locations == null) {
            this.m_locations = new Hashtable(1);
        }
        this.m_locations.put(new Integer(this.m_defaultWebAppId), theLocation);
        this.m_bHasChanged = true;
    }

    public void setLocations(Hashtable theLocations) throws VWException {
        if (theLocations == null) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadLocation", "Step processor info location cannot be null.");
        }
        if (theLocations != null) {
            Enumeration theKeys = theLocations.keys();
            Object aKey = null;
            Object aValue = null;
            for (int i = 0; i < theLocations.size(); ++i) {
                if (!theKeys.hasMoreElements()) continue;
                aKey = theKeys.nextElement();
                if (aKey == null || !(aKey instanceof Integer)) {
                    throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadLocationIndex", "Step processor info location id must be Integer.");
                }
                aValue = theLocations.get(aKey);
                if (aValue != null && aValue instanceof String) continue;
                throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadLocationString", "Step processor info location value must be String.");
            }
        }
        this.m_locations = theLocations;
        this.m_bHasChanged = true;
    }

    public void setProcessorType(int theProcessorType) throws VWException {
        if (theProcessorType == 1 || theProcessorType == 2 || theProcessorType == 4 || theProcessorType == 8) {
            this.m_processorType &= 0xFFFFFFF0;
            this.m_processorType |= theProcessorType;
        } else {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadType", "Illegal step processor info type.");
        }
        this.m_bHasChanged = true;
    }

    public void setAppType(int theAppType) throws VWException {
        if (theAppType == 32 || theAppType == 64) {
            this.m_processorType &= 0xFFFFFF9F;
            this.m_processorType |= theAppType;
        } else {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadAppType", "Illegal step processor info application type.");
        }
        this.m_bHasChanged = true;
    }

    public void setDefaultType(int theDefaultType) throws VWException {
        if (theDefaultType == 1 || theDefaultType == 2) {
            this.m_processorType &= 0xFFFFFFFC;
            this.m_processorType |= theDefaultType;
        } else {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadDefaultType", "Illegal step processor info default type.");
        }
        this.m_bHasChanged = true;
    }

    public void setHeight(int theHeight) throws VWException {
        if (theHeight <= 0) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadSize", "Illegal step processor info window size.");
        }
        this.m_height = theHeight;
        this.m_bHasChanged = true;
    }

    public void setWidth(int theWidth) throws VWException {
        if (theWidth <= 0) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadSize", "Illegal step processor info window size.");
        }
        this.m_width = theWidth;
        this.m_bHasChanged = true;
    }

    public void setHasChanged(boolean theNewValue) {
        super.setHasChanged(theNewValue);
    }

    public boolean hasChanged() {
        return super.hasChanged();
    }

    public void setApplicationName(String theApplicationName) throws VWException {
        if (theApplicationName == null) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionBadAppName", "Illegal step processor info application name.");
        }
        this.m_application = theApplicationName;
        this.m_bHasChanged = true;
    }

    protected void setDefaultWebAppId(int id) {
        super.setDefaultWebAppId(id);
    }

    protected void setIsolatedRegionWebAppId(int id) {
        super.setIsolatedRegionWebAppId(id);
    }

    public String toString() {
        return super.toString();
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        if (!this.isSelectedForExport) {
            return;
        }
        if (theBuffer == null) {
            throw new VWException("vw.api.VWStepProcessorInfoDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        String INDENT_2 = INDENT_1 + "\t";
        theBuffer.append(INDENT_0 + "<" + "StepProcessorInfoDefinition" + "\n");
        theBuffer.append(INDENT_1 + "Name" + "=\"" + VWXMLHandler.toXMLString(this.getName()) + "\"\n");
        theBuffer.append(INDENT_1 + "Id" + "=\"" + Integer.toString(this.getId()) + "\"\n");
        theBuffer.append(INDENT_1 + "Type" + "=\"" + Integer.toString(this.getProcessorType()) + "\"\n");
        theBuffer.append(INDENT_1 + "ApplicationName" + "=\"" + VWXMLHandler.toXMLString(this.getApplicationName()) + "\"\n");
        theBuffer.append(INDENT_1 + "AppType" + "=\"" + Integer.toString(this.getAppType()) + "\"\n");
        theBuffer.append(INDENT_1 + "IsDefaultType" + "=\"" + VWXMLHandler.booleanToString(this.isDefaultType()) + "\"\n");
        theBuffer.append(INDENT_1 + "Width" + "=\"" + Integer.toString(this.getWidth()) + "\"\n");
        theBuffer.append(INDENT_1 + "Height" + "=\"" + Integer.toString(this.getHeight()) + "\"\n");
        theBuffer.append(INDENT_1 + "IsolatedRegionWebAppId" + "=\"" + Integer.toString(super.getIsolatedRegionWebApp()) + "\"\n");
        theBuffer.append(INDENT_1 + "DefaultWebAppId" + "=\"" + Integer.toString(this.m_defaultWebAppId) + "\"");
        theBuffer.append(">\n");
        theBuffer.append(INDENT_1 + "<" + "ArrayOfLocation" + ">\n");
        Hashtable theLocations = this.getLocations();
        VWXMLConfiguration.hashtableToXML(theLocations, 1, theBuffer, "Location", INDENT_2);
        theBuffer.append(INDENT_1 + "</" + "ArrayOfLocation" + ">\n");
        theBuffer.append(INDENT_0 + "</" + "StepProcessorInfoDefinition" + ">\n");
    }

    protected void setIsSelectedForExport(boolean selectIt) {
        this.isSelectedForExport = selectIt;
    }

    protected boolean getIsSelectedForExport() {
        return this.isSelectedForExport;
    }
}

